﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using TheMVCPattern.Controllers;
using TheMVCPattern.Models;

namespace TestProject {


Listing 4.7. Przykadowa klasa osprztu testw
[TestClass] 
public class AdminControllerTest { 

    [TestMethod] 
    public void CanChangeLoginName() {

        // Przygotowanie (skonfigurowanie scenariusza)
        Member bob = new Member() { LoginName = "Bogdan" };
        FakeMembersRepository repositoryParam = new FakeMembersRepository(); 
        repositoryParam.Members.Add(bob); 
        AdminController target = new AdminController(repositoryParam); 
        string oldLoginParam = bob.LoginName; 
        string newLoginParam = "Anastazja";

        // Dziaanie (wykonanie operacji)
        target.ChangeLoginName(oldLoginParam, newLoginParam);

        // Asercje (weryfikacja wyniku)
        Assert.AreEqual(newLoginParam, bob.LoginName); 
        Assert.IsTrue(repositoryParam.DidSubmitChanges);
    } 
 
    private class FakeMembersRepository : IMembersRepository { 
        public List<Member> Members = new List<Member>(); 
        public bool DidSubmitChanges = false; 
 
        public void AddMember(Member member) { 
            throw new NotImplementedException(); 
        } 

        public Member FetchByLoginName(string loginName) { 
            return Members.First(m => m.LoginName == loginName); 
        } 
 
        public void SubmitChanges() { 
            DidSubmitChanges = true; 
        } 
    } 
}
